/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.manageconns;

import com.ibm.hwmca.fw.rcs.manageconns.RcsConnectionsConstants;
import com.ibm.hwmca.fw.rcs.path.PathIdentifier;
import com.ibm.hwmca.fw.rcs.path.PathPriority;
import com.ibm.hwmca.fw.util.LocalizableText;
import java.io.Serializable;
import java.util.Date;

public class RcsPathInfo
implements Serializable,
RcsConnectionsConstants {
    private String id;
    private String system;
    private LocalizableText priority;
    private Date createDate;
    private LocalizableText description;

    public RcsPathInfo(PathIdentifier pathId) {
        this.id = pathId.getPathId().toString();
        this.system = pathId.getSystem();
        this.priority = this.getLocalizablePriority(pathId.getPriority());
        this.createDate = pathId.getDate();
        this.description = pathId.getDescription();
    }

    public String getId() {
        return this.id;
    }

    public String getSystem() {
        return this.system;
    }

    public LocalizableText getPriority() {
        return this.priority;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public LocalizableText getDescription() {
        return this.description;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RcsPathInfo)) {
            return false;
        }
        RcsPathInfo pathInfo = (RcsPathInfo)obj;
        return this.id.equals(pathInfo.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{RcsPathInfo ");
        sb.append("id=" + this.id + ", ");
        sb.append("system=" + this.system + ", ");
        sb.append("priority=" + this.priority + ", ");
        sb.append("created=" + this.createDate + " , ");
        sb.append("desc=" + this.description + "]");
        return sb.toString();
    }

    private LocalizableText getLocalizablePriority(PathPriority priority) {
        if (priority == PathPriority.LOW) {
            return new LocalizableText("com.ibm.hwmca.fw.rcs.manageconns.res.RcsConnectionsMsgs", "PRIORITY_LOW");
        }
        if (priority == PathPriority.HIGH) {
            return new LocalizableText("com.ibm.hwmca.fw.rcs.manageconns.res.RcsConnectionsMsgs", "PRIORITY_HIGH");
        }
        return new LocalizableText("com.ibm.hwmca.fw.rcs.manageconns.res.RcsConnectionsMsgs", "PRIORITY_LOW");
    }
}

